
if exist('REVS','var') && (REVS.verbose > 0)  disp(['Loading ' mfilename]); end

electric = class_REVS_electric(engine);
run('battery_lead_acid_pack.m');

electric.matrix_vintage = enum_matrix_vintage.future;

%% Starter and Alternator Specs
electric.starter.min_voltage_V              = 6;
electric.starter.cranking_speed_radps       = 300 * convert.rpm2radps;
electric.starter.efficiency_norm            = 0.5;
electric.starter.inertia_kgm2               = 0.0;

electric.alternator.regen_enable            = false; % true;
electric.alternator.target_voltage_V        = interp1(electric.battery.cell.open_circuit_voltage_map_index_soc_norm, electric.battery.open_circuit_voltage_map_average_V(1,:), electric.battery.initial_soc_norm);
electric.alternator.inertia_kgm2            = 0;
electric.alternator.efficiency_norm         = 0.70;
electric.alternator.max_current_A           = 200;

electric.alternator.regen_brake_boost_gain = 95;

%% Define Electrical Accessory Power (W)
accessories                             = class_REVS_ALPHA_accessories;

temp.nominal_W          = 490;
temp.additional_HFET_W  = 0;    % additional highway/us06 accessory load for engine fan
temp.max_A              = 80;
temp.HFET_phase_num     = 4;
accessories.generic_loss                                            = class_REVS_accessory_load(temp.nominal_W, temp.max_A, 0, 0);
accessories.generic_loss.electrical_loss_map_A.axis_2.signal        = 'cycle_phase_num';
accessories.generic_loss.electrical_loss_map_A.axis_2.breakpoints   = [0, temp.HFET_phase_num - .001, temp.HFET_phase_num];
accessories.generic_loss.electrical_loss_map_A.table(:,2)           = accessories.generic_loss.electrical_loss_map_A.table(:,1);
accessories.generic_loss.electrical_loss_map_A.table(:,3)           = min(temp.max_A, accessories.generic_loss.electrical_loss_map_A.table(:,1) + temp.additional_HFET_W ./ accessories.generic_loss.electrical_loss_map_A.axis_1.breakpoints);

accessories.fan                                             = class_REVS_accessory_load(temp.additional_HFET_W, temp.max_A, 0, 0);
accessories.fan.electrical_loss_map_A.axis_2.signal         = 'cycle_phase_num';
accessories.fan.electrical_loss_map_A.axis_2.breakpoints    = [temp.HFET_phase_num - .001, temp.HFET_phase_num];
accessories.fan.electrical_loss_map_A.table(:,2)            = accessories.fan.electrical_loss_map_A.table(:,1);
accessories.fan.electrical_loss_map_A.table(:,1)            = zeros(size(accessories.fan.electrical_loss_map_A.table(:,1)));

accessories.power_steering              = class_REVS_accessory_load(0, 0, 0, 0);
accessories.air_conditioner             = class_REVS_accessory_load(0, 0, 0, 0);

clear temp;
